package physx.vehicle2;


public class PxVehicleFourWheelDriveDifferentialParams extends PxVehicleMultiWheelDriveDifferentialParams {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleFourWheelDriveDifferentialParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleFourWheelDriveDifferentialParams(address) : null;
    }
    
    public static PxVehicleFourWheelDriveDifferentialParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleFourWheelDriveDifferentialParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleFourWheelDriveDifferentialParams
     */
    public static PxVehicleFourWheelDriveDifferentialParams createAt(long address) {
        __placement_new_PxVehicleFourWheelDriveDifferentialParams(address);
        PxVehicleFourWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleFourWheelDriveDifferentialParams
     */
    public static <T> PxVehicleFourWheelDriveDifferentialParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleFourWheelDriveDifferentialParams(address);
        PxVehicleFourWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleFourWheelDriveDifferentialParams(long address);

    // Constructors

    public PxVehicleFourWheelDriveDifferentialParams() {
        address = _PxVehicleFourWheelDriveDifferentialParams();
    }
    private static native long _PxVehicleFourWheelDriveDifferentialParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getFrontWheelIds(int index) {
        checkNotNull();
        return _getFrontWheelIds(address, index);
    }
    private static native int _getFrontWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setFrontWheelIds(int index, int value) {
        checkNotNull();
        _setFrontWheelIds(address, index, value);
    }
    private static native void _setFrontWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getRearWheelIds(int index) {
        checkNotNull();
        return _getRearWheelIds(address, index);
    }
    private static native int _getRearWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setRearWheelIds(int index, int value) {
        checkNotNull();
        _setRearWheelIds(address, index, value);
    }
    private static native void _setRearWheelIds(long address, int index, int value);

    /**
     * @return WebIDL type: float
     */
    public float getFrontBias() {
        checkNotNull();
        return _getFrontBias(address);
    }
    private static native float _getFrontBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFrontBias(float value) {
        checkNotNull();
        _setFrontBias(address, value);
    }
    private static native void _setFrontBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getFrontTarget() {
        checkNotNull();
        return _getFrontTarget(address);
    }
    private static native float _getFrontTarget(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFrontTarget(float value) {
        checkNotNull();
        _setFrontTarget(address, value);
    }
    private static native void _setFrontTarget(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRearBias() {
        checkNotNull();
        return _getRearBias(address);
    }
    private static native float _getRearBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRearBias(float value) {
        checkNotNull();
        _setRearBias(address, value);
    }
    private static native void _setRearBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRearTarget() {
        checkNotNull();
        return _getRearTarget(address);
    }
    private static native float _getRearTarget(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRearTarget(float value) {
        checkNotNull();
        _setRearTarget(address, value);
    }
    private static native void _setRearTarget(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCenterBias() {
        checkNotNull();
        return _getCenterBias(address);
    }
    private static native float _getCenterBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCenterBias(float value) {
        checkNotNull();
        _setCenterBias(address, value);
    }
    private static native void _setCenterBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCenterTarget() {
        checkNotNull();
        return _getCenterTarget(address);
    }
    private static native float _getCenterTarget(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCenterTarget(float value) {
        checkNotNull();
        _setCenterTarget(address, value);
    }
    private static native void _setCenterTarget(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRate() {
        checkNotNull();
        return _getRate(address);
    }
    private static native float _getRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRate(float value) {
        checkNotNull();
        _setRate(address, value);
    }
    private static native void _setRate(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleFourWheelDriveDifferentialParams} [Value]
     */
    public PxVehicleFourWheelDriveDifferentialParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleFourWheelDriveDifferentialParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
