package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleGearboxState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleGearboxState wrapPointer(long address) {
        return address != 0L ? new PxVehicleGearboxState(address) : null;
    }
    
    public static PxVehicleGearboxState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleGearboxState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleGearboxState() {
        address = _PxVehicleGearboxState();
    }
    private static native long _PxVehicleGearboxState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCurrentGear() {
        checkNotNull();
        return _getCurrentGear(address);
    }
    private static native int _getCurrentGear(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCurrentGear(int value) {
        checkNotNull();
        _setCurrentGear(address, value);
    }
    private static native void _setCurrentGear(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTargetGear() {
        checkNotNull();
        return _getTargetGear(address);
    }
    private static native int _getTargetGear(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTargetGear(int value) {
        checkNotNull();
        _setTargetGear(address, value);
    }
    private static native void _setTargetGear(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getGearSwitchTime() {
        checkNotNull();
        return _getGearSwitchTime(address);
    }
    private static native float _getGearSwitchTime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setGearSwitchTime(float value) {
        checkNotNull();
        _setGearSwitchTime(address, value);
    }
    private static native void _setGearSwitchTime(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
