package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehiclePhysXConstraintState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXConstraintState wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXConstraintState(address) : null;
    }
    
    public static PxVehiclePhysXConstraintState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXConstraintState(long address) {
        super(address);
    }

    // Constructors

    public PxVehiclePhysXConstraintState() {
        address = _PxVehiclePhysXConstraintState();
    }
    private static native long _PxVehiclePhysXConstraintState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: boolean
     */
    public boolean getTireActiveStatus(int index) {
        checkNotNull();
        return _getTireActiveStatus(address, index);
    }
    private static native boolean _getTireActiveStatus(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: boolean
     */
    public void setTireActiveStatus(int index, boolean value) {
        checkNotNull();
        _setTireActiveStatus(address, index, value);
    }
    private static native void _setTireActiveStatus(long address, int index, boolean value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireLinears(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireLinears(address, index));
    }
    private static native long _getTireLinears(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireLinears(int index, PxVec3 value) {
        checkNotNull();
        _setTireLinears(address, index, value.getAddress());
    }
    private static native void _setTireLinears(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireAngulars(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireAngulars(address, index));
    }
    private static native long _getTireAngulars(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireAngulars(int index, PxVec3 value) {
        checkNotNull();
        _setTireAngulars(address, index, value.getAddress());
    }
    private static native void _setTireAngulars(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getTireDamping(int index) {
        checkNotNull();
        return _getTireDamping(address, index);
    }
    private static native float _getTireDamping(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setTireDamping(int index, float value) {
        checkNotNull();
        _setTireDamping(address, index, value);
    }
    private static native void _setTireDamping(long address, int index, float value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSuspActiveStatus() {
        checkNotNull();
        return _getSuspActiveStatus(address);
    }
    private static native boolean _getSuspActiveStatus(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setSuspActiveStatus(boolean value) {
        checkNotNull();
        _setSuspActiveStatus(address, value);
    }
    private static native void _setSuspActiveStatus(long address, boolean value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSuspLinear() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspLinear(address));
    }
    private static native long _getSuspLinear(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSuspLinear(PxVec3 value) {
        checkNotNull();
        _setSuspLinear(address, value.getAddress());
    }
    private static native void _setSuspLinear(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSuspAngular() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspAngular(address));
    }
    private static native long _getSuspAngular(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSuspAngular(PxVec3 value) {
        checkNotNull();
        _setSuspAngular(address, value.getAddress());
    }
    private static native void _setSuspAngular(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSuspGeometricError() {
        checkNotNull();
        return _getSuspGeometricError(address);
    }
    private static native float _getSuspGeometricError(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSuspGeometricError(float value) {
        checkNotNull();
        _setSuspGeometricError(address, value);
    }
    private static native void _setSuspGeometricError(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
