package physx.vehicle2;

import physx.NativeObject;
import physx.physics.PxConstraint;

public class PxVehiclePhysXConstraints extends NativeObject {

    protected PxVehiclePhysXConstraints() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXConstraints wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXConstraints(address) : null;
    }
    
    public static PxVehiclePhysXConstraints arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXConstraints(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehiclePhysXConstraintState} [Value]
     */
    public PxVehiclePhysXConstraintState getConstraintStates(int index) {
        checkNotNull();
        return PxVehiclePhysXConstraintState.wrapPointer(_getConstraintStates(address, index));
    }
    private static native long _getConstraintStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehiclePhysXConstraintState} [Value]
     */
    public void setConstraintStates(int index, PxVehiclePhysXConstraintState value) {
        checkNotNull();
        _setConstraintStates(address, index, value.getAddress());
    }
    private static native void _setConstraintStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxConstraint}
     */
    public PxConstraint getConstraints(int index) {
        checkNotNull();
        return PxConstraint.wrapPointer(_getConstraints(address, index));
    }
    private static native long _getConstraints(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxConstraint}
     */
    public void setConstraints(int index, PxConstraint value) {
        checkNotNull();
        _setConstraints(address, index, value.getAddress());
    }
    private static native void _setConstraints(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleConstraintConnector}
     */
    public PxVehicleConstraintConnector getConstraintConnectors(int index) {
        checkNotNull();
        return PxVehicleConstraintConnector.wrapPointer(_getConstraintConnectors(address, index));
    }
    private static native long _getConstraintConnectors(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleConstraintConnector}
     */
    public void setConstraintConnectors(int index, PxVehicleConstraintConnector value) {
        checkNotNull();
        _setConstraintConnectors(address, index, value.getAddress());
    }
    private static native void _setConstraintConnectors(long address, int index, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
