package physx.vehicle2;

import physx.NativeObject;
import physx.physics.PxMaterial;

public class PxVehiclePhysXMaterialFriction extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXMaterialFriction wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXMaterialFriction(address) : null;
    }
    
    public static PxVehiclePhysXMaterialFriction arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXMaterialFriction(long address) {
        super(address);
    }

    // Constructors

    public PxVehiclePhysXMaterialFriction() {
        address = _PxVehiclePhysXMaterialFriction();
    }
    private static native long _PxVehiclePhysXMaterialFriction();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxMaterial} [Const]
     */
    public PxMaterial getMaterial() {
        checkNotNull();
        return PxMaterial.wrapPointer(_getMaterial(address));
    }
    private static native long _getMaterial(long address);

    /**
     * @param value WebIDL type: {@link PxMaterial} [Const]
     */
    public void setMaterial(PxMaterial value) {
        checkNotNull();
        _setMaterial(address, value.getAddress());
    }
    private static native void _setMaterial(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getFriction() {
        checkNotNull();
        return _getFriction(address);
    }
    private static native float _getFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFriction(float value) {
        checkNotNull();
        _setFriction(address, value);
    }
    private static native void _setFriction(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
