package physx.vehicle2;

import physx.NativeObject;

public class PxVehiclePhysXSteerState extends NativeObject {

    protected PxVehiclePhysXSteerState() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXSteerState wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXSteerState(address) : null;
    }
    
    public static PxVehiclePhysXSteerState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXSteerState(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getPreviousSteerCommand() {
        checkNotNull();
        return _getPreviousSteerCommand(address);
    }
    private static native float _getPreviousSteerCommand(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPreviousSteerCommand(float value) {
        checkNotNull();
        _setPreviousSteerCommand(address, value);
    }
    private static native void _setPreviousSteerCommand(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
