package physx.vehicle2;

import physx.NativeObject;

public class PxVehiclePvdContext extends NativeObject {

    protected PxVehiclePvdContext() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePvdContext wrapPointer(long address) {
        return address != 0L ? new PxVehiclePvdContext(address) : null;
    }
    
    public static PxVehiclePvdContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePvdContext(long address) {
        super(address);
    }

}
