package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleRigidBodyParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleRigidBodyParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleRigidBodyParams(address) : null;
    }
    
    public static PxVehicleRigidBodyParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleRigidBodyParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleRigidBodyParams() {
        address = _PxVehicleRigidBodyParams();
    }
    private static native long _PxVehicleRigidBodyParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMass() {
        checkNotNull();
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMass(float value) {
        checkNotNull();
        _setMass(address, value);
    }
    private static native void _setMass(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMoi() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMoi(address));
    }
    private static native long _getMoi(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMoi(PxVec3 value) {
        checkNotNull();
        _setMoi(address, value.getAddress());
    }
    private static native void _setMoi(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleRigidBodyParams} [Value]
     */
    public PxVehicleRigidBodyParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleRigidBodyParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
