package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxPlane;
import physx.common.PxVec3;

public class PxVehicleRoadGeometryState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleRoadGeometryState wrapPointer(long address) {
        return address != 0L ? new PxVehicleRoadGeometryState(address) : null;
    }
    
    public static PxVehicleRoadGeometryState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleRoadGeometryState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleRoadGeometryState() {
        address = _PxVehicleRoadGeometryState();
    }
    private static native long _PxVehicleRoadGeometryState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxPlane} [Value]
     */
    public PxPlane getPlane() {
        checkNotNull();
        return PxPlane.wrapPointer(_getPlane(address));
    }
    private static native long _getPlane(long address);

    /**
     * @param value WebIDL type: {@link PxPlane} [Value]
     */
    public void setPlane(PxPlane value) {
        checkNotNull();
        _setPlane(address, value.getAddress());
    }
    private static native void _setPlane(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getFriction() {
        checkNotNull();
        return _getFriction(address);
    }
    private static native float _getFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFriction(float value) {
        checkNotNull();
        _setFriction(address, value);
    }
    private static native void _setFriction(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getVelocity(address));
    }
    private static native long _getVelocity(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setVelocity(PxVec3 value) {
        checkNotNull();
        _setVelocity(address, value.getAddress());
    }
    private static native void _setVelocity(long address, long value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getHitState() {
        checkNotNull();
        return _getHitState(address);
    }
    private static native boolean _getHitState(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setHitState(boolean value) {
        checkNotNull();
        _setHitState(address, value);
    }
    private static native void _setHitState(long address, boolean value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
