package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleSuspensionComplianceParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionComplianceParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionComplianceParams(address) : null;
    }
    
    public static PxVehicleSuspensionComplianceParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionComplianceParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionComplianceParams() {
        address = _PxVehicleSuspensionComplianceParams();
    }
    private static native long _PxVehicleSuspensionComplianceParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleFixedSizeLookupTableFloat_3} [Value]
     */
    public PxVehicleFixedSizeLookupTableFloat_3 getWheelToeAngle() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableFloat_3.wrapPointer(_getWheelToeAngle(address));
    }
    private static native long _getWheelToeAngle(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFixedSizeLookupTableFloat_3} [Value]
     */
    public void setWheelToeAngle(PxVehicleFixedSizeLookupTableFloat_3 value) {
        checkNotNull();
        _setWheelToeAngle(address, value.getAddress());
    }
    private static native void _setWheelToeAngle(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleFixedSizeLookupTableFloat_3} [Value]
     */
    public PxVehicleFixedSizeLookupTableFloat_3 getWheelCamberAngle() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableFloat_3.wrapPointer(_getWheelCamberAngle(address));
    }
    private static native long _getWheelCamberAngle(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFixedSizeLookupTableFloat_3} [Value]
     */
    public void setWheelCamberAngle(PxVehicleFixedSizeLookupTableFloat_3 value) {
        checkNotNull();
        _setWheelCamberAngle(address, value.getAddress());
    }
    private static native void _setWheelCamberAngle(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleFixedSizeLookupTableVec3_3} [Value]
     */
    public PxVehicleFixedSizeLookupTableVec3_3 getSuspForceAppPoint() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableVec3_3.wrapPointer(_getSuspForceAppPoint(address));
    }
    private static native long _getSuspForceAppPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFixedSizeLookupTableVec3_3} [Value]
     */
    public void setSuspForceAppPoint(PxVehicleFixedSizeLookupTableVec3_3 value) {
        checkNotNull();
        _setSuspForceAppPoint(address, value.getAddress());
    }
    private static native void _setSuspForceAppPoint(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleFixedSizeLookupTableVec3_3} [Value]
     */
    public PxVehicleFixedSizeLookupTableVec3_3 getTireForceAppPoint() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableVec3_3.wrapPointer(_getTireForceAppPoint(address));
    }
    private static native long _getTireForceAppPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFixedSizeLookupTableVec3_3} [Value]
     */
    public void setTireForceAppPoint(PxVehicleFixedSizeLookupTableVec3_3 value) {
        checkNotNull();
        _setTireForceAppPoint(address, value.getAddress());
    }
    private static native void _setTireForceAppPoint(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSuspensionComplianceParams} [Value]
     */
    public PxVehicleSuspensionComplianceParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSuspensionComplianceParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
