package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleSuspensionComplianceState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionComplianceState wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionComplianceState(address) : null;
    }
    
    public static PxVehicleSuspensionComplianceState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionComplianceState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionComplianceState() {
        address = _PxVehicleSuspensionComplianceState();
    }
    private static native long _PxVehicleSuspensionComplianceState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getToe() {
        checkNotNull();
        return _getToe(address);
    }
    private static native float _getToe(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setToe(float value) {
        checkNotNull();
        _setToe(address, value);
    }
    private static native void _setToe(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCamber() {
        checkNotNull();
        return _getCamber(address);
    }
    private static native float _getCamber(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCamber(float value) {
        checkNotNull();
        _setCamber(address, value);
    }
    private static native void _setCamber(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireForceAppPoint() {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireForceAppPoint(address));
    }
    private static native long _getTireForceAppPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireForceAppPoint(PxVec3 value) {
        checkNotNull();
        _setTireForceAppPoint(address, value.getAddress());
    }
    private static native void _setTireForceAppPoint(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSuspForceAppPoint() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspForceAppPoint(address));
    }
    private static native long _getSuspForceAppPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSuspForceAppPoint(PxVec3 value) {
        checkNotNull();
        _setSuspForceAppPoint(address, value.getAddress());
    }
    private static native void _setSuspForceAppPoint(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
