package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleSuspensionForce extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionForce wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionForce(address) : null;
    }
    
    public static PxVehicleSuspensionForce arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionForce(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionForce() {
        address = _PxVehicleSuspensionForce();
    }
    private static native long _PxVehicleSuspensionForce();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getForce() {
        checkNotNull();
        return PxVec3.wrapPointer(_getForce(address));
    }
    private static native long _getForce(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setForce(PxVec3 value) {
        checkNotNull();
        _setForce(address, value.getAddress());
    }
    private static native void _setForce(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTorque() {
        checkNotNull();
        return PxVec3.wrapPointer(_getTorque(address));
    }
    private static native long _getTorque(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTorque(PxVec3 value) {
        checkNotNull();
        _setTorque(address, value.getAddress());
    }
    private static native void _setTorque(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getNormalForce() {
        checkNotNull();
        return _getNormalForce(address);
    }
    private static native float _getNormalForce(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setNormalForce(float value) {
        checkNotNull();
        _setNormalForce(address, value);
    }
    private static native void _setNormalForce(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
