package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleSuspensionForceParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionForceParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionForceParams(address) : null;
    }
    
    public static PxVehicleSuspensionForceParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionForceParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionForceParams() {
        address = _PxVehicleSuspensionForceParams();
    }
    private static native long _PxVehicleSuspensionForceParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getSprungMass() {
        checkNotNull();
        return _getSprungMass(address);
    }
    private static native float _getSprungMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSprungMass(float value) {
        checkNotNull();
        _setSprungMass(address, value);
    }
    private static native void _setSprungMass(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSuspensionForceParams} [Value]
     */
    public PxVehicleSuspensionForceParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSuspensionForceParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
