package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleSuspensionState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionState wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionState(address) : null;
    }
    
    public static PxVehicleSuspensionState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionState() {
        address = _PxVehicleSuspensionState();
    }
    private static native long _PxVehicleSuspensionState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getJounce() {
        checkNotNull();
        return _getJounce(address);
    }
    private static native float _getJounce(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setJounce(float value) {
        checkNotNull();
        _setJounce(address, value);
    }
    private static native void _setJounce(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getJounceSpeed() {
        checkNotNull();
        return _getJounceSpeed(address);
    }
    private static native float _getJounceSpeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setJounceSpeed(float value) {
        checkNotNull();
        _setJounceSpeed(address, value);
    }
    private static native void _setJounceSpeed(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    // Functions

    /**
     * @param _jounce     WebIDL type: float
     * @param _separation WebIDL type: float
     */
    public void setToDefault(float _jounce, float _separation) {
        checkNotNull();
        _setToDefault(address, _jounce, _separation);
    }
    private static native void _setToDefault(long address, float _jounce, float _separation);

}
