package physx.vehicle2;

import physx.support.PxU32ConstPtr;

public class PxVehicleTankDriveDifferentialParams extends PxVehicleMultiWheelDriveDifferentialParams {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTankDriveDifferentialParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTankDriveDifferentialParams(address) : null;
    }
    
    public static PxVehicleTankDriveDifferentialParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTankDriveDifferentialParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTankDriveDifferentialParams
     */
    public static PxVehicleTankDriveDifferentialParams createAt(long address) {
        __placement_new_PxVehicleTankDriveDifferentialParams(address);
        PxVehicleTankDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTankDriveDifferentialParams
     */
    public static <T> PxVehicleTankDriveDifferentialParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTankDriveDifferentialParams(address);
        PxVehicleTankDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTankDriveDifferentialParams(long address);

    // Constructors

    public PxVehicleTankDriveDifferentialParams() {
        address = _PxVehicleTankDriveDifferentialParams();
    }
    private static native long _PxVehicleTankDriveDifferentialParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTracks() {
        checkNotNull();
        return _getNbTracks(address);
    }
    private static native int _getNbTracks(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbTracks(int value) {
        checkNotNull();
        _setNbTracks(address, value);
    }
    private static native void _setNbTracks(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getThrustIdPerTrack(int index) {
        checkNotNull();
        return _getThrustIdPerTrack(address, index);
    }
    private static native int _getThrustIdPerTrack(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setThrustIdPerTrack(int index, int value) {
        checkNotNull();
        _setThrustIdPerTrack(address, index, value);
    }
    private static native void _setThrustIdPerTrack(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsPerTrack(int index) {
        checkNotNull();
        return _getNbWheelsPerTrack(address, index);
    }
    private static native int _getNbWheelsPerTrack(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsPerTrack(int index, int value) {
        checkNotNull();
        _setNbWheelsPerTrack(address, index, value);
    }
    private static native void _setNbWheelsPerTrack(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getTrackToWheelIds(int index) {
        checkNotNull();
        return _getTrackToWheelIds(address, index);
    }
    private static native int _getTrackToWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setTrackToWheelIds(int index, int value) {
        checkNotNull();
        _setTrackToWheelIds(address, index, value);
    }
    private static native void _setTrackToWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIdsInTrackOrder(int index) {
        checkNotNull();
        return _getWheelIdsInTrackOrder(address, index);
    }
    private static native int _getWheelIdsInTrackOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIdsInTrackOrder(int index, int value) {
        checkNotNull();
        _setWheelIdsInTrackOrder(address, index, value);
    }
    private static native void _setWheelIdsInTrackOrder(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getTorqueRatios(int index) {
        checkNotNull();
        return _getTorqueRatios(address, index);
    }
    private static native float _getTorqueRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setTorqueRatios(int index, float value) {
        checkNotNull();
        _setTorqueRatios(address, index, value);
    }
    private static native void _setTorqueRatios(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getAveWheelSpeedRatios(int index) {
        checkNotNull();
        return _getAveWheelSpeedRatios(address, index);
    }
    private static native float _getAveWheelSpeedRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setAveWheelSpeedRatios(int index, float value) {
        checkNotNull();
        _setAveWheelSpeedRatios(address, index, value);
    }
    private static native void _setAveWheelSpeedRatios(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsInTrack(int i) {
        checkNotNull();
        return _getNbWheelsInTrack(address, i);
    }
    private static native int _getNbWheelsInTrack(long address, int i);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: {@link PxU32ConstPtr} [Value]
     */
    public PxU32ConstPtr getWheelsInTrack(int i) {
        checkNotNull();
        return PxU32ConstPtr.wrapPointer(_getWheelsInTrack(address, i));
    }
    private static native long _getWheelsInTrack(long address, int i);

    /**
     * @param j WebIDL type: unsigned long
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getWheelInTrack(int j, int i) {
        checkNotNull();
        return _getWheelInTrack(address, j, i);
    }
    private static native int _getWheelInTrack(long address, int j, int i);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getThrustControllerIndex(int i) {
        checkNotNull();
        return _getThrustControllerIndex(address, i);
    }
    private static native int _getThrustControllerIndex(long address, int i);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTankDriveDifferentialParams} [Value]
     */
    public PxVehicleTankDriveDifferentialParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTankDriveDifferentialParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
