package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireAxisStickyParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireAxisStickyParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireAxisStickyParams(address) : null;
    }
    
    public static PxVehicleTireAxisStickyParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireAxisStickyParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTireAxisStickyParams
     */
    public static PxVehicleTireAxisStickyParams createAt(long address) {
        __placement_new_PxVehicleTireAxisStickyParams(address);
        PxVehicleTireAxisStickyParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTireAxisStickyParams
     */
    public static <T> PxVehicleTireAxisStickyParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTireAxisStickyParams(address);
        PxVehicleTireAxisStickyParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTireAxisStickyParams(long address);

    // Constructors

    public PxVehicleTireAxisStickyParams() {
        address = _PxVehicleTireAxisStickyParams();
    }
    private static native long _PxVehicleTireAxisStickyParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getThresholdSpeed() {
        checkNotNull();
        return _getThresholdSpeed(address);
    }
    private static native float _getThresholdSpeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setThresholdSpeed(float value) {
        checkNotNull();
        _setThresholdSpeed(address, value);
    }
    private static native void _setThresholdSpeed(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getThresholdTime() {
        checkNotNull();
        return _getThresholdTime(address);
    }
    private static native float _getThresholdTime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setThresholdTime(float value) {
        checkNotNull();
        _setThresholdTime(address, value);
    }
    private static native void _setThresholdTime(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTireAxisStickyParams} [Value]
     */
    public PxVehicleTireAxisStickyParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTireAxisStickyParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
