package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleTireForce extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireForce wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireForce(address) : null;
    }
    
    public static PxVehicleTireForce arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireForce(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireForce() {
        address = _PxVehicleTireForce();
    }
    private static native long _PxVehicleTireForce();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getForces(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getForces(address, index));
    }
    private static native long _getForces(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setForces(int index, PxVec3 value) {
        checkNotNull();
        _setForces(address, index, value.getAddress());
    }
    private static native void _setForces(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTorques(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTorques(address, index));
    }
    private static native long _getTorques(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTorques(int index, PxVec3 value) {
        checkNotNull();
        _setTorques(address, index, value.getAddress());
    }
    private static native void _setTorques(long address, int index, long value);

    /**
     * @return WebIDL type: float
     */
    public float getAligningMoment() {
        checkNotNull();
        return _getAligningMoment(address);
    }
    private static native float _getAligningMoment(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setAligningMoment(float value) {
        checkNotNull();
        _setAligningMoment(address, value);
    }
    private static native void _setAligningMoment(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getWheelTorque() {
        checkNotNull();
        return _getWheelTorque(address);
    }
    private static native float _getWheelTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setWheelTorque(float value) {
        checkNotNull();
        _setWheelTorque(address, value);
    }
    private static native void _setWheelTorque(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
