package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireForceParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireForceParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireForceParams(address) : null;
    }
    
    public static PxVehicleTireForceParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireForceParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireForceParams() {
        address = _PxVehicleTireForceParams();
    }
    private static native long _PxVehicleTireForceParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getLatStiffX() {
        checkNotNull();
        return _getLatStiffX(address);
    }
    private static native float _getLatStiffX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLatStiffX(float value) {
        checkNotNull();
        _setLatStiffX(address, value);
    }
    private static native void _setLatStiffX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLatStiffY() {
        checkNotNull();
        return _getLatStiffY(address);
    }
    private static native float _getLatStiffY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLatStiffY(float value) {
        checkNotNull();
        _setLatStiffY(address, value);
    }
    private static native void _setLatStiffY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLongStiff() {
        checkNotNull();
        return _getLongStiff(address);
    }
    private static native float _getLongStiff(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLongStiff(float value) {
        checkNotNull();
        _setLongStiff(address, value);
    }
    private static native void _setLongStiff(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCamberStiff() {
        checkNotNull();
        return _getCamberStiff(address);
    }
    private static native float _getCamberStiff(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCamberStiff(float value) {
        checkNotNull();
        _setCamberStiff(address, value);
    }
    private static native void _setCamberStiff(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRestLoad() {
        checkNotNull();
        return _getRestLoad(address);
    }
    private static native float _getRestLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRestLoad(float value) {
        checkNotNull();
        _setRestLoad(address, value);
    }
    private static native void _setRestLoad(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTireForceParams} [Value]
     */
    public PxVehicleTireForceParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTireForceParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
