package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireGripState extends NativeObject {

    protected PxVehicleTireGripState() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireGripState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireGripState(address) : null;
    }
    
    public static PxVehicleTireGripState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireGripState(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getLoad() {
        checkNotNull();
        return _getLoad(address);
    }
    private static native float _getLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLoad(float value) {
        checkNotNull();
        _setLoad(address, value);
    }
    private static native void _setLoad(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getFriction() {
        checkNotNull();
        return _getFriction(address);
    }
    private static native float _getFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFriction(float value) {
        checkNotNull();
        _setFriction(address, value);
    }
    private static native void _setFriction(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
