package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireSlipState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireSlipState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireSlipState(address) : null;
    }
    
    public static PxVehicleTireSlipState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireSlipState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireSlipState() {
        address = _PxVehicleTireSlipState();
    }
    private static native long _PxVehicleTireSlipState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getSlips(int index) {
        checkNotNull();
        return _getSlips(address, index);
    }
    private static native float _getSlips(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setSlips(int index, float value) {
        checkNotNull();
        _setSlips(address, index, value);
    }
    private static native void _setSlips(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
