package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireSpeedState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireSpeedState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireSpeedState(address) : null;
    }
    
    public static PxVehicleTireSpeedState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireSpeedState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireSpeedState() {
        address = _PxVehicleTireSpeedState();
    }
    private static native long _PxVehicleTireSpeedState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getSpeedStates(int index) {
        checkNotNull();
        return _getSpeedStates(address, index);
    }
    private static native float _getSpeedStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setSpeedStates(int index, float value) {
        checkNotNull();
        _setSpeedStates(address, index, value);
    }
    private static native void _setSpeedStates(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
