package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireStickyParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireStickyParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireStickyParams(address) : null;
    }
    
    public static PxVehicleTireStickyParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireStickyParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTireStickyParams
     */
    public static PxVehicleTireStickyParams createAt(long address) {
        __placement_new_PxVehicleTireStickyParams(address);
        PxVehicleTireStickyParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTireStickyParams
     */
    public static <T> PxVehicleTireStickyParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTireStickyParams(address);
        PxVehicleTireStickyParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTireStickyParams(long address);

    // Constructors

    public PxVehicleTireStickyParams() {
        address = _PxVehicleTireStickyParams();
    }
    private static native long _PxVehicleTireStickyParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireAxisStickyParams} [Value]
     */
    public PxVehicleTireAxisStickyParams getStickyParams(int index) {
        checkNotNull();
        return PxVehicleTireAxisStickyParams.wrapPointer(_getStickyParams(address, index));
    }
    private static native long _getStickyParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireAxisStickyParams} [Value]
     */
    public void setStickyParams(int index, PxVehicleTireAxisStickyParams value) {
        checkNotNull();
        _setStickyParams(address, index, value.getAddress());
    }
    private static native void _setStickyParams(long address, int index, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTireStickyParams} [Value]
     */
    public PxVehicleTireStickyParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTireStickyParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
