package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireStickyState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireStickyState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireStickyState(address) : null;
    }
    
    public static PxVehicleTireStickyState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireStickyState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireStickyState() {
        address = _PxVehicleTireStickyState();
    }
    private static native long _PxVehicleTireStickyState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getLowSpeedTime(int index) {
        checkNotNull();
        return _getLowSpeedTime(address, index);
    }
    private static native float _getLowSpeedTime(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setLowSpeedTime(int index, float value) {
        checkNotNull();
        _setLowSpeedTime(address, index, value);
    }
    private static native void _setLowSpeedTime(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: boolean
     */
    public boolean getActiveStatus(int index) {
        checkNotNull();
        return _getActiveStatus(address, index);
    }
    private static native boolean _getActiveStatus(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: boolean
     */
    public void setActiveStatus(int index, boolean value) {
        checkNotNull();
        _setActiveStatus(address, index, value);
    }
    private static native void _setActiveStatus(long address, int index, boolean value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
