package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTorqueCurveLookupTable extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTorqueCurveLookupTable wrapPointer(long address) {
        return address != 0L ? new PxVehicleTorqueCurveLookupTable(address) : null;
    }
    
    public static PxVehicleTorqueCurveLookupTable arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTorqueCurveLookupTable(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTorqueCurveLookupTable() {
        address = _PxVehicleTorqueCurveLookupTable();
    }
    private static native long _PxVehicleTorqueCurveLookupTable();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean addPair(float x, float y) {
        checkNotNull();
        return _addPair(address, x, y);
    }
    private static native boolean _addPair(long address, float x, float y);

    /**
     * @param x WebIDL type: float
     * @return WebIDL type: float
     */
    public float interpolate(float x) {
        checkNotNull();
        return _interpolate(address, x);
    }
    private static native float _interpolate(long address, float x);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
