package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleWheelActuationState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelActuationState wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelActuationState(address) : null;
    }
    
    public static PxVehicleWheelActuationState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelActuationState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelActuationState() {
        address = _PxVehicleWheelActuationState();
    }
    private static native long _PxVehicleWheelActuationState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: boolean
     */
    public boolean getIsBrakeApplied() {
        checkNotNull();
        return _getIsBrakeApplied(address);
    }
    private static native boolean _getIsBrakeApplied(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setIsBrakeApplied(boolean value) {
        checkNotNull();
        _setIsBrakeApplied(address, value);
    }
    private static native void _setIsBrakeApplied(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getIsDriveApplied() {
        checkNotNull();
        return _getIsDriveApplied(address);
    }
    private static native boolean _getIsDriveApplied(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setIsDriveApplied(boolean value) {
        checkNotNull();
        _setIsDriveApplied(address, value);
    }
    private static native void _setIsDriveApplied(long address, boolean value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
