package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleWheelConstraintGroupState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelConstraintGroupState wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelConstraintGroupState(address) : null;
    }
    
    public static PxVehicleWheelConstraintGroupState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelConstraintGroupState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelConstraintGroupState() {
        address = _PxVehicleWheelConstraintGroupState();
    }
    private static native long _PxVehicleWheelConstraintGroupState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbGroups() {
        checkNotNull();
        return _getNbGroups(address);
    }
    private static native int _getNbGroups(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbGroups(int value) {
        checkNotNull();
        _setNbGroups(address, value);
    }
    private static native void _setNbGroups(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsPerGroup(int index) {
        checkNotNull();
        return _getNbWheelsPerGroup(address, index);
    }
    private static native int _getNbWheelsPerGroup(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsPerGroup(int index, int value) {
        checkNotNull();
        _setNbWheelsPerGroup(address, index, value);
    }
    private static native void _setNbWheelsPerGroup(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getGroupToWheelIds(int index) {
        checkNotNull();
        return _getGroupToWheelIds(address, index);
    }
    private static native int _getGroupToWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setGroupToWheelIds(int index, int value) {
        checkNotNull();
        _setGroupToWheelIds(address, index, value);
    }
    private static native void _setGroupToWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIdsInGroupOrder(int index) {
        checkNotNull();
        return _getWheelIdsInGroupOrder(address, index);
    }
    private static native int _getWheelIdsInGroupOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIdsInGroupOrder(int index, int value) {
        checkNotNull();
        _setWheelIdsInGroupOrder(address, index, value);
    }
    private static native void _setWheelIdsInGroupOrder(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getWheelMultipliersInGroupOrder(int index) {
        checkNotNull();
        return _getWheelMultipliersInGroupOrder(address, index);
    }
    private static native float _getWheelMultipliersInGroupOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setWheelMultipliersInGroupOrder(int index, float value) {
        checkNotNull();
        _setWheelMultipliersInGroupOrder(address, index, value);
    }
    private static native void _setWheelMultipliersInGroupOrder(long address, int index, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsInGroups() {
        checkNotNull();
        return _getNbWheelsInGroups(address);
    }
    private static native int _getNbWheelsInGroups(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsInGroups(int value) {
        checkNotNull();
        _setNbWheelsInGroups(address, value);
    }
    private static native void _setNbWheelsInGroups(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbConstraintGroups() {
        checkNotNull();
        return _getNbConstraintGroups(address);
    }
    private static native int _getNbConstraintGroups(long address);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsInConstraintGroup(int i) {
        checkNotNull();
        return _getNbWheelsInConstraintGroup(address, i);
    }
    private static native int _getNbWheelsInConstraintGroup(long address, int i);

    /**
     * @param j WebIDL type: unsigned long
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getWheelInConstraintGroup(int j, int i) {
        checkNotNull();
        return _getWheelInConstraintGroup(address, j, i);
    }
    private static native int _getWheelInConstraintGroup(long address, int j, int i);

    /**
     * @param j WebIDL type: unsigned long
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getMultiplierInConstraintGroup(int j, int i) {
        checkNotNull();
        return _getMultiplierInConstraintGroup(address, j, i);
    }
    private static native float _getMultiplierInConstraintGroup(long address, int j, int i);

}
