package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;

public class PxVehicleWheelLocalPose extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelLocalPose wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelLocalPose(address) : null;
    }
    
    public static PxVehicleWheelLocalPose arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelLocalPose(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelLocalPose() {
        address = _PxVehicleWheelLocalPose();
    }
    private static native long _PxVehicleWheelLocalPose();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getLocalPose(address));
    }
    private static native long _getLocalPose(long address);

    /**
     * @param value WebIDL type: {@link PxTransform} [Value]
     */
    public void setLocalPose(PxTransform value) {
        checkNotNull();
        _setLocalPose(address, value.getAddress());
    }
    private static native void _setLocalPose(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
