package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleWheelParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelParams(address) : null;
    }
    
    public static PxVehicleWheelParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelParams() {
        address = _PxVehicleWheelParams();
    }
    private static native long _PxVehicleWheelParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHalfWidth() {
        checkNotNull();
        return _getHalfWidth(address);
    }
    private static native float _getHalfWidth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfWidth(float value) {
        checkNotNull();
        _setHalfWidth(address, value);
    }
    private static native void _setHalfWidth(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMass() {
        checkNotNull();
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMass(float value) {
        checkNotNull();
        _setMass(address, value);
    }
    private static native void _setMass(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMoi() {
        checkNotNull();
        return _getMoi(address);
    }
    private static native float _getMoi(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMoi(float value) {
        checkNotNull();
        _setMoi(address, value);
    }
    private static native void _setMoi(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDampingRate() {
        checkNotNull();
        return _getDampingRate(address);
    }
    private static native float _getDampingRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDampingRate(float value) {
        checkNotNull();
        _setDampingRate(address, value);
    }
    private static native void _setDampingRate(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleWheelParams} [Value]
     */
    public PxVehicleWheelParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleWheelParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
