package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleWheelRigidBody1dState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelRigidBody1dState wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelRigidBody1dState(address) : null;
    }
    
    public static PxVehicleWheelRigidBody1dState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelRigidBody1dState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelRigidBody1dState() {
        address = _PxVehicleWheelRigidBody1dState();
    }
    private static native long _PxVehicleWheelRigidBody1dState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRotationSpeed() {
        checkNotNull();
        return _getRotationSpeed(address);
    }
    private static native float _getRotationSpeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRotationSpeed(float value) {
        checkNotNull();
        _setRotationSpeed(address, value);
    }
    private static native void _setRotationSpeed(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCorrectedRotationSpeed() {
        checkNotNull();
        return _getCorrectedRotationSpeed(address);
    }
    private static native float _getCorrectedRotationSpeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCorrectedRotationSpeed(float value) {
        checkNotNull();
        _setCorrectedRotationSpeed(address, value);
    }
    private static native void _setCorrectedRotationSpeed(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getRotationAngle() {
        checkNotNull();
        return _getRotationAngle(address);
    }
    private static native float _getRotationAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRotationAngle(float value) {
        checkNotNull();
        _setRotationAngle(address, value);
    }
    private static native void _setRotationAngle(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
