/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;

public class PxRealPtr
extends NativeObject {
    public static final int SIZEOF = PxRealPtr.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRealPtr() {
    }

    private static native int __sizeOf();

    public static PxRealPtr wrapPointer(long address) {
        return address != 0L ? new PxRealPtr(address) : null;
    }

    public static PxRealPtr arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRealPtr.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRealPtr(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxRealPtr._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);
}

