package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec4;

/**
 * Compressed form of cone limit parameters
 */
public class PxConeLimitParams extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxConeLimitParams");
    }

    protected PxConeLimitParams() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConeLimitParams wrapPointer(long address) {
        return address != 0L ? new PxConeLimitParams(address) : null;
    }
    
    public static PxConeLimitParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConeLimitParams(long address) {
        super(address);
    }

    // Placed Constructors

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public PxVec4 getLowHighLimits() {
        checkNotNull();
        return PxVec4.wrapPointer(_getLowHighLimits(address));
    }
    private static native long _getLowHighLimits(long address);

    /**
     */
    public void setLowHighLimits(PxVec4 value) {
        checkNotNull();
        _setLowHighLimits(address, value.getAddress());
    }
    private static native void _setLowHighLimits(long address, long value);

    /**
     */
    public PxVec4 getAxisAngle() {
        checkNotNull();
        return PxVec4.wrapPointer(_getAxisAngle(address));
    }
    private static native long _getAxisAngle(long address);

    /**
     */
    public void setAxisAngle(PxVec4 value) {
        checkNotNull();
        _setAxisAngle(address, value.getAddress());
    }
    private static native void _setAxisAngle(long address, long value);

}
