package physx.physics;

/**
 * These flags determine what data is read or written to the internal articulation data via cache.
 * <p>
 * <b>See also:</b> PxArticulationCache PxArticulationReducedCoordinate::copyInternalStateToCache PxArticulationReducedCoordinate::applyCache
 */
public enum PxArticulationCacheFlagEnum {

    /**
     * The joint velocities, see PxArticulationCache::jointVelocity.
     */
    eVELOCITY(geteVELOCITY()),
    /**
     * The joint accelerations, see PxArticulationCache::jointAcceleration.
     */
    eACCELERATION(geteACCELERATION()),
    /**
     * The joint positions, see PxArticulationCache::jointPosition.
     */
    ePOSITION(getePOSITION()),
    /**
     * The joint forces, see PxArticulationCache::jointForce.
     */
    eFORCE(geteFORCE()),
    /**
     * The link velocities, see PxArticulationCache::linkVelocity. Link velocities cannot be set except for the root link velocity via  PxArticulationCache::rootLinkData.
     */
    eLINK_VELOCITY(geteLINK_VELOCITY()),
    /**
     * The link accelerations, see PxArticulationCache::linkAcceleration.
     */
    eLINK_ACCELERATION(geteLINK_ACCELERATION()),
    /**
     * Root link transform, see PxArticulationCache::rootLinkData.
     */
    eROOT_TRANSFORM(geteROOT_TRANSFORM()),
    /**
     * Root link velocities (read/write) and accelerations (read), see PxArticulationCache::rootLinkData.
     */
    eROOT_VELOCITIES(geteROOT_VELOCITIES()),
    /**
     * Link incoming joint forces, see PxArticulationCache::linkIncomingJointForce.
     */
    eLINK_INCOMING_JOINT_FORCE(geteLINK_INCOMING_JOINT_FORCE()),
    /**
     * The joint target positions, see PxArticulationCache::jointTargetPositions.
     */
    eJOINT_TARGET_POSITIONS(geteJOINT_TARGET_POSITIONS()),
    /**
     * The joint target velocities, see PxArticulationCache::jointTargetVelocities.
     */
    eJOINT_TARGET_VELOCITIES(geteJOINT_TARGET_VELOCITIES()),
    eALL(geteALL());
    public final int value;
    
    PxArticulationCacheFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteVELOCITY();
    private static int geteVELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteVELOCITY();
    }

    private static native int _geteACCELERATION();
    private static int geteACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteACCELERATION();
    }

    private static native int _getePOSITION();
    private static int getePOSITION() {
        de.fabmax.physxjni.Loader.load();
        return _getePOSITION();
    }

    private static native int _geteFORCE();
    private static int geteFORCE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFORCE();
    }

    private static native int _geteLINK_VELOCITY();
    private static int geteLINK_VELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteLINK_VELOCITY();
    }

    private static native int _geteLINK_ACCELERATION();
    private static int geteLINK_ACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteLINK_ACCELERATION();
    }

    private static native int _geteROOT_TRANSFORM();
    private static int geteROOT_TRANSFORM() {
        de.fabmax.physxjni.Loader.load();
        return _geteROOT_TRANSFORM();
    }

    private static native int _geteROOT_VELOCITIES();
    private static int geteROOT_VELOCITIES() {
        de.fabmax.physxjni.Loader.load();
        return _geteROOT_VELOCITIES();
    }

    private static native int _geteLINK_INCOMING_JOINT_FORCE();
    private static int geteLINK_INCOMING_JOINT_FORCE() {
        de.fabmax.physxjni.Loader.load();
        return _geteLINK_INCOMING_JOINT_FORCE();
    }

    private static native int _geteJOINT_TARGET_POSITIONS();
    private static int geteJOINT_TARGET_POSITIONS() {
        de.fabmax.physxjni.Loader.load();
        return _geteJOINT_TARGET_POSITIONS();
    }

    private static native int _geteJOINT_TARGET_VELOCITIES();
    private static int geteJOINT_TARGET_VELOCITIES() {
        de.fabmax.physxjni.Loader.load();
        return _geteJOINT_TARGET_VELOCITIES();
    }

    private static native int _geteALL();
    private static int geteALL() {
        de.fabmax.physxjni.Loader.load();
        return _geteALL();
    }

    public static PxArticulationCacheFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationCacheFlagEnum: " + value);
    }

}
