package physx.support;

import physx.NativeObject;
import physx.physics.PxSweepHit;

public class PxArray_PxSweepHit extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxSweepHit wrapPointer(long address) {
        return address != 0L ? new PxArray_PxSweepHit(address) : null;
    }
    
    public static PxArray_PxSweepHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxSweepHit(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxSweepHit
     */
    public static PxArray_PxSweepHit createAt(long address) {
        __placement_new_PxArray_PxSweepHit(address);
        PxArray_PxSweepHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxSweepHit
     */
    public static <T> PxArray_PxSweepHit createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxSweepHit(address);
        PxArray_PxSweepHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxSweepHit(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxSweepHit
     */
    public static PxArray_PxSweepHit createAt(long address, int size) {
        __placement_new_PxArray_PxSweepHit(address, size);
        PxArray_PxSweepHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxSweepHit
     */
    public static <T> PxArray_PxSweepHit createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxSweepHit(address, size);
        PxArray_PxSweepHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxSweepHit(long address, int size);

    // Constructors

    public PxArray_PxSweepHit() {
        address = _PxArray_PxSweepHit();
    }
    private static native long _PxArray_PxSweepHit();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxSweepHit(int size) {
        address = _PxArray_PxSweepHit(size);
    }
    private static native long _PxArray_PxSweepHit(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSweepHit} [Ref]
     */
    public PxSweepHit get(int index) {
        checkNotNull();
        return PxSweepHit.wrapPointer(_get(address, index));
    }
    private static native long _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: {@link PxSweepHit} [Const, Ref]
     */
    public void set(int index, PxSweepHit value) {
        checkNotNull();
        _set(address, index, value.getAddress());
    }
    private static native void _set(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxSweepHit}
     */
    public PxSweepHit begin() {
        checkNotNull();
        return PxSweepHit.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxSweepHit} [Ref]
     */
    public void pushBack(PxSweepHit value) {
        checkNotNull();
        _pushBack(address, value.getAddress());
    }
    private static native void _pushBack(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
