package physx.support;

import physx.NativeObject;

public class PxArray_PxU16 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxU16 wrapPointer(long address) {
        return address != 0L ? new PxArray_PxU16(address) : null;
    }
    
    public static PxArray_PxU16 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxU16(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxU16
     */
    public static PxArray_PxU16 createAt(long address) {
        __placement_new_PxArray_PxU16(address);
        PxArray_PxU16 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxU16
     */
    public static <T> PxArray_PxU16 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxU16(address);
        PxArray_PxU16 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxU16(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxU16
     */
    public static PxArray_PxU16 createAt(long address, int size) {
        __placement_new_PxArray_PxU16(address, size);
        PxArray_PxU16 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxU16
     */
    public static <T> PxArray_PxU16 createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxU16(address, size);
        PxArray_PxU16 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxU16(long address, int size);

    // Constructors

    public PxArray_PxU16() {
        address = _PxArray_PxU16();
    }
    private static native long _PxArray_PxU16();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxU16(int size) {
        address = _PxArray_PxU16(size);
    }
    private static native long _PxArray_PxU16(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: unsigned short
     */
    public short get(int index) {
        checkNotNull();
        return _get(address, index);
    }
    private static native short _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: unsigned short
     */
    public void set(int index, short value) {
        checkNotNull();
        _set(address, index, value);
    }
    private static native void _set(long address, int index, short value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject begin() {
        checkNotNull();
        return NativeObject.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: unsigned short
     */
    public void pushBack(short value) {
        checkNotNull();
        _pushBack(address, value);
    }
    private static native void _pushBack(long address, short value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
