package physx.support;

import physx.NativeObject;

@Deprecated
public class Vector_PxU8 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Vector_PxU8 wrapPointer(long address) {
        return address != 0L ? new Vector_PxU8(address) : null;
    }
    
    public static Vector_PxU8 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Vector_PxU8(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxU8() {
        address = _Vector_PxU8();
    }
    private static native long _Vector_PxU8();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxU8(int size) {
        address = _Vector_PxU8(size);
    }
    private static native long _Vector_PxU8(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: octet
     */
    public byte at(int index) {
        checkNotNull();
        return _at(address, index);
    }
    private static native byte _at(long address, int index);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject data() {
        checkNotNull();
        return NativeObject.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void push_back(byte value) {
        checkNotNull();
        _push_back(address, value);
    }
    private static native void _push_back(long address, byte value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
