package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

/**
 * PxVehicleTireDirectionState stores the world frame lateral and longtidinal axes of the tire after 
 * projecting the wheel pose in the world frame onto the road geometry plane (also in the world frame).
 */
public class PxVehicleTireDirectionState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireDirectionState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireDirectionState(address) : null;
    }
    
    public static PxVehicleTireDirectionState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireDirectionState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireDirectionState() {
        address = _PxVehicleTireDirectionState();
    }
    private static native long _PxVehicleTireDirectionState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getDirections(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getDirections(address, index));
    }
    private static native long _getDirections(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setDirections(int index, PxVec3 value) {
        checkNotNull();
        _setDirections(address, index, value.getAddress());
    }
    private static native void _setDirections(long address, int index, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
