package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.cooking.PxCookingParams;
import physx.geometry.PxConvexMesh;
import physx.physics.PxPhysics;
import physx.support.PxArray_PxReal;
import physx.support.PxArray_PxVec3;

public class PxVehicleTopLevelFunctions extends NativeObject {

    protected PxVehicleTopLevelFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxVehicleTopLevelFunctions(address) : null;
    }
    
    public static PxVehicleTopLevelFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTopLevelFunctions(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public static int getMAX_NB_ENGINE_TORQUE_CURVE_ENTRIES() {
        return _getMAX_NB_ENGINE_TORQUE_CURVE_ENTRIES();
    }
    private static native int _getMAX_NB_ENGINE_TORQUE_CURVE_ENTRIES();

    // Functions

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean InitVehicleExtension(PxFoundation foundation) {
        return _InitVehicleExtension(foundation.getAddress());
    }
    private static native boolean _InitVehicleExtension(long foundation);

    public static void CloseVehicleExtension() {
        _CloseVehicleExtension();
    }
    private static native void _CloseVehicleExtension();

    /**
     * @param nbSprungMasses        WebIDL type: unsigned long
     * @param sprungMassCoordinates WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param totalMass             WebIDL type: float
     * @param gravityDirection      WebIDL type: {@link PxVehicleAxesEnum} [enum]
     * @param sprungMasses          WebIDL type: {@link PxArray_PxReal} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean VehicleComputeSprungMasses(int nbSprungMasses, PxArray_PxVec3 sprungMassCoordinates, float totalMass, PxVehicleAxesEnum gravityDirection, PxArray_PxReal sprungMasses) {
        return _VehicleComputeSprungMasses(nbSprungMasses, sprungMassCoordinates.getAddress(), totalMass, gravityDirection.value, sprungMasses.getAddress());
    }
    private static native boolean _VehicleComputeSprungMasses(int nbSprungMasses, long sprungMassCoordinates, float totalMass, int gravityDirection, long sprungMasses);

    /**
     * @param vehicleFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param physics      WebIDL type: {@link PxPhysics} [Ref]
     * @param params       WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @return WebIDL type: {@link PxConvexMesh}
     */
    public static PxConvexMesh VehicleUnitCylinderSweepMeshCreate(PxVehicleFrame vehicleFrame, PxPhysics physics, PxCookingParams params) {
        return PxConvexMesh.wrapPointer(_VehicleUnitCylinderSweepMeshCreate(vehicleFrame.getAddress(), physics.getAddress(), params.getAddress()));
    }
    private static native long _VehicleUnitCylinderSweepMeshCreate(long vehicleFrame, long physics, long params);

    /**
     * @param mesh WebIDL type: {@link PxConvexMesh}
     */
    public static void VehicleUnitCylinderSweepMeshDestroy(PxConvexMesh mesh) {
        _VehicleUnitCylinderSweepMeshDestroy(mesh.getAddress());
    }
    private static native void _VehicleUnitCylinderSweepMeshDestroy(long mesh);

}
