package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class Vector_VHACDTriangle extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.Vector_VHACDTriangle");
    }

    protected Vector_VHACDTriangle() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Vector_VHACDTriangle wrapPointer(long address) {
        return address != 0L ? new Vector_VHACDTriangle(address) : null;
    }
    
    public static Vector_VHACDTriangle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Vector_VHACDTriangle(long address) {
        super(address);
    }

    // Placed Constructors

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link VHACDTriangle} [Ref]
     */
    public VHACDTriangle at(int index) {
        checkNotNull();
        return VHACDTriangle.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link VHACDTriangle}
     */
    public VHACDTriangle data() {
        checkNotNull();
        return VHACDTriangle.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link VHACDTriangle} [Ref]
     */
    public void push_back(VHACDTriangle value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
