package physx.common;

import physx.NativeObject;

public class PxMat33 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxMat33 wrapPointer(long address) {
        return address != 0L ? new PxMat33(address) : null;
    }
    
    public static PxMat33 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxMat33(long address) {
        super(address);
    }

    // Constructors

    public PxMat33() {
        address = _PxMat33();
    }
    private static native long _PxMat33();

    /**
     * @param r WebIDL type: {@link PxIDENTITYEnum} [enum]
     */
    public PxMat33(PxIDENTITYEnum r) {
        address = _PxMat33(r.value);
    }
    private static native long _PxMat33(int r);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn0() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn0(address));
    }
    private static native long _getColumn0(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn0(PxVec3 value) {
        checkNotNull();
        _setColumn0(address, value.getAddress());
    }
    private static native void _setColumn0(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn1() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn1(address));
    }
    private static native long _getColumn1(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn1(PxVec3 value) {
        checkNotNull();
        _setColumn1(address, value.getAddress());
    }
    private static native void _setColumn1(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn2() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn2(address));
    }
    private static native long _getColumn2(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn2(PxVec3 value) {
        checkNotNull();
        _setColumn2(address, value.getAddress());
    }
    private static native void _setColumn2(long address, long value);

}
