package physx.common;

import physx.NativeObject;

public class PxQuat extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxQuat wrapPointer(long address) {
        return address != 0L ? new PxQuat(address) : null;
    }
    
    public static PxQuat arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxQuat(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat createAt(long address) {
        __placement_new_PxQuat(address);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQuat(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param r       WebIDL type: {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat createAt(long address, PxIDENTITYEnum r) {
        __placement_new_PxQuat(address, r.value);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param r         WebIDL type: {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat createAt(T allocator, Allocator<T> allocate, PxIDENTITYEnum r) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address, r.value);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQuat(long address, int r);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param x       WebIDL type: float
     * @param y       WebIDL type: float
     * @param z       WebIDL type: float
     * @param w       WebIDL type: float
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat createAt(long address, float x, float y, float z, float w) {
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         WebIDL type: float
     * @param y         WebIDL type: float
     * @param z         WebIDL type: float
     * @param w         WebIDL type: float
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat createAt(T allocator, Allocator<T> allocate, float x, float y, float z, float w) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQuat(long address, float x, float y, float z, float w);

    // Constructors

    public PxQuat() {
        address = _PxQuat();
    }
    private static native long _PxQuat();

    /**
     * @param r WebIDL type: {@link PxIDENTITYEnum} [enum]
     */
    public PxQuat(PxIDENTITYEnum r) {
        address = _PxQuat(r.value);
    }
    private static native long _PxQuat(int r);

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     * @param z WebIDL type: float
     * @param w WebIDL type: float
     */
    public PxQuat(float x, float y, float z, float w) {
        address = _PxQuat(x, y, z, w);
    }
    private static native long _PxQuat(float x, float y, float z, float w);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getX() {
        checkNotNull();
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setX(float value) {
        checkNotNull();
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getY() {
        checkNotNull();
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setY(float value) {
        checkNotNull();
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZ() {
        checkNotNull();
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZ(float value) {
        checkNotNull();
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getW() {
        checkNotNull();
        return _getW(address);
    }
    private static native float _getW(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setW(float value) {
        checkNotNull();
        _setW(address, value);
    }
    private static native void _setW(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isIdentity() {
        checkNotNull();
        return _isIdentity(address);
    }
    private static native boolean _isIdentity(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isFinite() {
        checkNotNull();
        return _isFinite(address);
    }
    private static native boolean _isFinite(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isUnit() {
        checkNotNull();
        return _isUnit(address);
    }
    private static native boolean _isUnit(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSane() {
        checkNotNull();
        return _isSane(address);
    }
    private static native boolean _isSane(long address);

    /**
     * @return WebIDL type: float
     */
    public float getAngle() {
        checkNotNull();
        return _getAngle(address);
    }
    private static native float _getAngle(long address);

    /**
     * @param q WebIDL type: {@link PxQuat} [Const, Ref]
     * @return WebIDL type: float
     */
    public float getAngle(PxQuat q) {
        checkNotNull();
        return _getAngle(address, q.getAddress());
    }
    private static native float _getAngle(long address, long q);

    /**
     * @return WebIDL type: float
     */
    public float magnitudeSquared() {
        checkNotNull();
        return _magnitudeSquared(address);
    }
    private static native float _magnitudeSquared(long address);

    /**
     * @param q WebIDL type: {@link PxQuat} [Const, Ref]
     * @return WebIDL type: float
     */
    public float dot(PxQuat q) {
        checkNotNull();
        return _dot(address, q.getAddress());
    }
    private static native float _dot(long address, long q);

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getNormalized() {
        checkNotNull();
        return PxQuat.wrapPointer(_getNormalized(address));
    }
    private static native long _getNormalized(long address);

    /**
     * @return WebIDL type: float
     */
    public float magnitude() {
        checkNotNull();
        return _magnitude(address);
    }
    private static native float _magnitude(long address);

    /**
     * @return WebIDL type: float
     */
    public float normalize() {
        checkNotNull();
        return _normalize(address);
    }
    private static native float _normalize(long address);

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getConjugate() {
        checkNotNull();
        return PxQuat.wrapPointer(_getConjugate(address));
    }
    private static native long _getConjugate(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getImaginaryPart() {
        checkNotNull();
        return PxVec3.wrapPointer(_getImaginaryPart(address));
    }
    private static native long _getImaginaryPart(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getBasisVector0() {
        checkNotNull();
        return PxVec3.wrapPointer(_getBasisVector0(address));
    }
    private static native long _getBasisVector0(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getBasisVector1() {
        checkNotNull();
        return PxVec3.wrapPointer(_getBasisVector1(address));
    }
    private static native long _getBasisVector1(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getBasisVector2() {
        checkNotNull();
        return PxVec3.wrapPointer(_getBasisVector2(address));
    }
    private static native long _getBasisVector2(long address);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 rotate(PxVec3 v) {
        checkNotNull();
        return PxVec3.wrapPointer(_rotate(address, v.getAddress()));
    }
    private static native long _rotate(long address, long v);

    /**
     * @param v WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 rotateInv(PxVec3 v) {
        checkNotNull();
        return PxVec3.wrapPointer(_rotateInv(address, v.getAddress()));
    }
    private static native long _rotateInv(long address, long v);

}
