package physx.extensions;

/**
 * Used to specify one of the degrees of freedom of  a D6 joint.
 * <p>
 * <b>See also:</b> PxD6Joint
 */
public enum PxD6AxisEnum {

    /**
     * motion along the X axis
     */
    eX(geteX()),
    /**
     * motion along the Y axis
     */
    eY(geteY()),
    /**
     * motion along the Z axis
     */
    eZ(geteZ()),
    /**
     * motion around the X axis
     */
    eTWIST(geteTWIST()),
    /**
     * motion around the Y axis
     */
    eSWING1(geteSWING1()),
    /**
     * motion around the Z axis
     */
    eSWING2(geteSWING2());
    public final int value;
    
    PxD6AxisEnum(int value) {
        this.value = value;
    }

    private static native int _geteX();
    private static int geteX() {
        de.fabmax.physxjni.Loader.load();
        return _geteX();
    }

    private static native int _geteY();
    private static int geteY() {
        de.fabmax.physxjni.Loader.load();
        return _geteY();
    }

    private static native int _geteZ();
    private static int geteZ() {
        de.fabmax.physxjni.Loader.load();
        return _geteZ();
    }

    private static native int _geteTWIST();
    private static int geteTWIST() {
        de.fabmax.physxjni.Loader.load();
        return _geteTWIST();
    }

    private static native int _geteSWING1();
    private static int geteSWING1() {
        de.fabmax.physxjni.Loader.load();
        return _geteSWING1();
    }

    private static native int _geteSWING2();
    private static int geteSWING2() {
        de.fabmax.physxjni.Loader.load();
        return _geteSWING2();
    }

    public static PxD6AxisEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxD6AxisEnum: " + value);
    }

}
