package physx.extensions;


public class PxJointAngularLimitPair extends PxJointLimitParameters {

    protected PxJointAngularLimitPair() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointAngularLimitPair wrapPointer(long address) {
        return address != 0L ? new PxJointAngularLimitPair(address) : null;
    }
    
    public static PxJointAngularLimitPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointAngularLimitPair(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param lowerLimit WebIDL type: float
     * @param upperLimit WebIDL type: float
     * @return Stack allocated object of PxJointAngularLimitPair
     */
    public static PxJointAngularLimitPair createAt(long address, float lowerLimit, float upperLimit) {
        __placement_new_PxJointAngularLimitPair(address, lowerLimit, upperLimit);
        PxJointAngularLimitPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param lowerLimit WebIDL type: float
     * @param upperLimit WebIDL type: float
     * @return Stack allocated object of PxJointAngularLimitPair
     */
    public static <T> PxJointAngularLimitPair createAt(T allocator, Allocator<T> allocate, float lowerLimit, float upperLimit) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointAngularLimitPair(address, lowerLimit, upperLimit);
        PxJointAngularLimitPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointAngularLimitPair(long address, float lowerLimit, float upperLimit);

    /**
     * @param address    Pre-allocated memory, where the object is created.
     * @param lowerLimit WebIDL type: float
     * @param upperLimit WebIDL type: float
     * @param spring     WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointAngularLimitPair
     */
    public static PxJointAngularLimitPair createAt(long address, float lowerLimit, float upperLimit, PxSpring spring) {
        __placement_new_PxJointAngularLimitPair(address, lowerLimit, upperLimit, spring.getAddress());
        PxJointAngularLimitPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>        Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator  Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate   Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param lowerLimit WebIDL type: float
     * @param upperLimit WebIDL type: float
     * @param spring     WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointAngularLimitPair
     */
    public static <T> PxJointAngularLimitPair createAt(T allocator, Allocator<T> allocate, float lowerLimit, float upperLimit, PxSpring spring) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointAngularLimitPair(address, lowerLimit, upperLimit, spring.getAddress());
        PxJointAngularLimitPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointAngularLimitPair(long address, float lowerLimit, float upperLimit, long spring);

    // Constructors

    /**
     * construct an angular hard limit pair. 
     * <p>
     * The lower value must be less than the upper value. 
     * @param lowerLimit The lower angle of the limit
     * @param upperLimit The upper angle of the limit
     * @see PxJointLimitParameters
     */
    public PxJointAngularLimitPair(float lowerLimit, float upperLimit) {
        address = _PxJointAngularLimitPair(lowerLimit, upperLimit);
    }
    private static native long _PxJointAngularLimitPair(float lowerLimit, float upperLimit);

    /**
     * construct an angular soft limit pair. 
     * <p>
     * The lower value must be less than the upper value. 
     * @param lowerLimit The lower angle of the limit
     * @param upperLimit The upper angle of the limit
     * @param spring  The stiffness and damping of the limit spring
     * @see PxJointLimitParameters
     */
    public PxJointAngularLimitPair(float lowerLimit, float upperLimit, PxSpring spring) {
        address = _PxJointAngularLimitPair(lowerLimit, upperLimit, spring.getAddress());
    }
    private static native long _PxJointAngularLimitPair(float lowerLimit, float upperLimit, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getUpper() {
        checkNotNull();
        return _getUpper(address);
    }
    private static native float _getUpper(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setUpper(float value) {
        checkNotNull();
        _setUpper(address, value);
    }
    private static native void _setUpper(long address, float value);

    /**
     * the range of the limit. The upper limit must be no lower than the lower limit.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> See the joint on which the limit is used for details<br>
     * <b>Default:</b> lower = -PI/2, upper = PI/2
     */
    public float getLower() {
        checkNotNull();
        return _getLower(address);
    }
    private static native float _getLower(long address);

    /**
     * the range of the limit. The upper limit must be no lower than the lower limit.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> See the joint on which the limit is used for details<br>
     * <b>Default:</b> lower = -PI/2, upper = PI/2
     */
    public void setLower(float value) {
        checkNotNull();
        _setLower(address, value);
    }
    private static native void _setLower(long address, float value);

}
