package physx.extensions;


/**
 * Describes a pyramidal joint limit.
 * @see PxD6Joint
 */
public class PxJointLimitPyramid extends PxJointLimitParameters {

    protected PxJointLimitPyramid() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxJointLimitPyramid wrapPointer(long address) {
        return address != 0L ? new PxJointLimitPyramid(address) : null;
    }
    
    public static PxJointLimitPyramid arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxJointLimitPyramid(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address        Pre-allocated memory, where the object is created.
     * @param yLimitAngleMin WebIDL type: float
     * @param yLimitAngleMax WebIDL type: float
     * @param zLimitAngleMin WebIDL type: float
     * @param zLimitAngleMax WebIDL type: float
     * @return Stack allocated object of PxJointLimitPyramid
     */
    public static PxJointLimitPyramid createAt(long address, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax) {
        __placement_new_PxJointLimitPyramid(address, yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax);
        PxJointLimitPyramid createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>            Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator      Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate       Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param yLimitAngleMin WebIDL type: float
     * @param yLimitAngleMax WebIDL type: float
     * @param zLimitAngleMin WebIDL type: float
     * @param zLimitAngleMax WebIDL type: float
     * @return Stack allocated object of PxJointLimitPyramid
     */
    public static <T> PxJointLimitPyramid createAt(T allocator, Allocator<T> allocate, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointLimitPyramid(address, yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax);
        PxJointLimitPyramid createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointLimitPyramid(long address, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax);

    /**
     * @param address        Pre-allocated memory, where the object is created.
     * @param yLimitAngleMin WebIDL type: float
     * @param yLimitAngleMax WebIDL type: float
     * @param zLimitAngleMin WebIDL type: float
     * @param zLimitAngleMax WebIDL type: float
     * @param spring         WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointLimitPyramid
     */
    public static PxJointLimitPyramid createAt(long address, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, PxSpring spring) {
        __placement_new_PxJointLimitPyramid(address, yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax, spring.getAddress());
        PxJointLimitPyramid createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>            Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator      Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate       Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param yLimitAngleMin WebIDL type: float
     * @param yLimitAngleMax WebIDL type: float
     * @param zLimitAngleMin WebIDL type: float
     * @param zLimitAngleMax WebIDL type: float
     * @param spring         WebIDL type: {@link PxSpring} [Const, Ref]
     * @return Stack allocated object of PxJointLimitPyramid
     */
    public static <T> PxJointLimitPyramid createAt(T allocator, Allocator<T> allocate, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, PxSpring spring) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxJointLimitPyramid(address, yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax, spring.getAddress());
        PxJointLimitPyramid createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxJointLimitPyramid(long address, float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, long spring);

    // Constructors

    /**
     * Construct a pyramid hard limit. 
     * @param yLimitAngleMin The minimum limit angle from the Y-axis of the constraint frame
     * @param yLimitAngleMax The maximum limit angle from the Y-axis of the constraint frame
     * @param zLimitAngleMin The minimum limit angle from the Z-axis of the constraint frame
     * @param zLimitAngleMax The maximum limit angle from the Z-axis of the constraint frame
     * @see PxJointLimitParameters
     */
    public PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax) {
        address = _PxJointLimitPyramid(yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax);
    }
    private static native long _PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax);

    /**
     * Construct a pyramid soft limit. 
     * @param yLimitAngleMin The minimum limit angle from the Y-axis of the constraint frame
     * @param yLimitAngleMax The maximum limit angle from the Y-axis of the constraint frame
     * @param zLimitAngleMin The minimum limit angle from the Z-axis of the constraint frame
     * @param zLimitAngleMax The maximum limit angle from the Z-axis of the constraint frame
     * @param spring   The stiffness and damping of the limit spring
     * @see PxJointLimitParameters
     */
    public PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, PxSpring spring) {
        address = _PxJointLimitPyramid(yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax, spring.getAddress());
    }
    private static native long _PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * the minimum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> -PI/2
     */
    public float getYAngleMin() {
        checkNotNull();
        return _getYAngleMin(address);
    }
    private static native float _getYAngleMin(long address);

    /**
     * the minimum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> -PI/2
     */
    public void setYAngleMin(float value) {
        checkNotNull();
        _setYAngleMin(address, value);
    }
    private static native void _setYAngleMin(long address, float value);

    /**
     * the maximum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> PI/2
     */
    public float getYAngleMax() {
        checkNotNull();
        return _getYAngleMax(address);
    }
    private static native float _getYAngleMax(long address);

    /**
     * the maximum angle from the Y axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> PI/2
     */
    public void setYAngleMax(float value) {
        checkNotNull();
        _setYAngleMax(address, value);
    }
    private static native void _setYAngleMax(long address, float value);

    /**
     * the minimum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> -PI/2
     */
    public float getZAngleMin() {
        checkNotNull();
        return _getZAngleMin(address);
    }
    private static native float _getZAngleMin(long address);

    /**
     * the minimum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> -PI/2
     */
    public void setZAngleMin(float value) {
        checkNotNull();
        _setZAngleMin(address, value);
    }
    private static native void _setZAngleMin(long address, float value);

    /**
     * the maximum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> PI/2
     */
    public float getZAngleMax() {
        checkNotNull();
        return _getZAngleMax(address);
    }
    private static native float _getZAngleMax(long address);

    /**
     * the maximum angle from the Z-axis of the constraint frame.
     * <p>
     * <b>Unit:</b> Angular: Radians
     * <b>Range:</b> Angular: (-PI,PI)<br>
     * <b>Default:</b> PI/2
     */
    public void setZAngleMax(float value) {
        checkNotNull();
        _setZAngleMax(address, value);
    }
    private static native void _setZAngleMax(long address, float value);

}
