package physx.geometry;

/**
 * Enum with flag values to be used in PxHeightFieldDesc.flags.
 */
public enum PxHeightFieldFlagEnum {

    /**
     * Disable collisions with height field with boundary edges.
     * <p>
     * Raise this flag if several terrain patches are going to be placed adjacent to each other, 
     * to avoid a bump when sliding across.
     * <p>
     * This flag is ignored in contact generation with sphere and capsule shapes.
     * <p>
     * <b>See also:</b> PxHeightFieldDesc.flags
     */
    eNO_BOUNDARY_EDGES(geteNO_BOUNDARY_EDGES());
    public final int value;
    
    PxHeightFieldFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteNO_BOUNDARY_EDGES();
    private static int geteNO_BOUNDARY_EDGES() {
        de.fabmax.physxjni.Loader.load();
        return _geteNO_BOUNDARY_EDGES();
    }

    public static PxHeightFieldFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxHeightFieldFlagEnum: " + value);
    }

}
