package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec4;
import physx.support.PxU32Ptr;

public class PxParticleClothBufferHelper extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothBufferHelper");
    }

    protected PxParticleClothBufferHelper() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothBufferHelper wrapPointer(long address) {
        return address != 0L ? new PxParticleClothBufferHelper(address) : null;
    }
    
    public static PxParticleClothBufferHelper arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothBufferHelper(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxCloths() {
        checkNotNull();
        return _getMaxCloths(address);
    }
    private static native int _getMaxCloths(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumCloths() {
        checkNotNull();
        return _getNumCloths(address);
    }
    private static native int _getNumCloths(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxSprings() {
        checkNotNull();
        return _getMaxSprings(address);
    }
    private static native int _getMaxSprings(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumSprings() {
        checkNotNull();
        return _getNumSprings(address);
    }
    private static native int _getNumSprings(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxTriangles() {
        checkNotNull();
        return _getMaxTriangles(address);
    }
    private static native int _getMaxTriangles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumTriangles() {
        checkNotNull();
        return _getNumTriangles(address);
    }
    private static native int _getNumTriangles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxParticles() {
        checkNotNull();
        return _getMaxParticles(address);
    }
    private static native int _getMaxParticles(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNumParticles() {
        checkNotNull();
        return _getNumParticles(address);
    }
    private static native int _getNumParticles(long address);

    /**
     * @param particleCloth WebIDL type: {@link PxParticleCloth} [Const, Ref]
     * @param triangles     WebIDL type: {@link PxU32Ptr} [Const, Ref]
     * @param numTriangles  WebIDL type: unsigned long
     * @param springs       WebIDL type: {@link PxParticleSpring} [Const]
     * @param numSprings    WebIDL type: unsigned long
     * @param restPositions WebIDL type: {@link PxVec4} [Const]
     * @param numParticles  WebIDL type: unsigned long
     */
    public void addCloth(PxParticleCloth particleCloth, PxU32Ptr triangles, int numTriangles, PxParticleSpring springs, int numSprings, PxVec4 restPositions, int numParticles) {
        checkNotNull();
        _addCloth(address, particleCloth.getAddress(), triangles.getAddress(), numTriangles, springs.getAddress(), numSprings, restPositions.getAddress(), numParticles);
    }
    private static native void _addCloth(long address, long particleCloth, long triangles, int numTriangles, long springs, int numSprings, long restPositions, int numParticles);

    /**
     * @param blendScale    WebIDL type: float
     * @param restVolume    WebIDL type: float
     * @param pressure      WebIDL type: float
     * @param triangles     WebIDL type: {@link PxU32Ptr} [Const, Ref]
     * @param numTriangles  WebIDL type: unsigned long
     * @param springs       WebIDL type: {@link PxParticleSpring} [Const]
     * @param numSprings    WebIDL type: unsigned long
     * @param restPositions WebIDL type: {@link PxVec4} [Const]
     * @param numParticles  WebIDL type: unsigned long
     */
    public void addCloth(float blendScale, float restVolume, float pressure, PxU32Ptr triangles, int numTriangles, PxParticleSpring springs, int numSprings, PxVec4 restPositions, int numParticles) {
        checkNotNull();
        _addCloth(address, blendScale, restVolume, pressure, triangles.getAddress(), numTriangles, springs.getAddress(), numSprings, restPositions.getAddress(), numParticles);
    }
    private static native void _addCloth(long address, float blendScale, float restVolume, float pressure, long triangles, int numTriangles, long springs, int numSprings, long restPositions, int numParticles);

    /**
     * @return WebIDL type: {@link PxParticleClothDesc} [Ref]
     */
    public PxParticleClothDesc getParticleClothDesc() {
        checkNotNull();
        return PxParticleClothDesc.wrapPointer(_getParticleClothDesc(address));
    }
    private static native long _getParticleClothDesc(long address);

}
