package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxParticleClothCooker extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothCooker");
    }

    protected PxParticleClothCooker() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothCooker wrapPointer(long address) {
        return address != 0L ? new PxParticleClothCooker(address) : null;
    }
    
    public static PxParticleClothCooker arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothCooker(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    public void cookConstraints() {
        checkNotNull();
        _cookConstraints(address);
    }
    private static native void _cookConstraints(long address);

    /**
     * @param constraints WebIDL type: {@link PxParticleClothConstraint} [Const]
     */
    public void cookConstraints(PxParticleClothConstraint constraints) {
        checkNotNull();
        _cookConstraints(address, constraints.getAddress());
    }
    private static native void _cookConstraints(long address, long constraints);

    /**
     * @param constraints    WebIDL type: {@link PxParticleClothConstraint} [Const]
     * @param numConstraints WebIDL type: unsigned long
     */
    public void cookConstraints(PxParticleClothConstraint constraints, int numConstraints) {
        checkNotNull();
        _cookConstraints(address, constraints.getAddress(), numConstraints);
    }
    private static native void _cookConstraints(long address, long constraints, int numConstraints);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getTriangleIndices() {
        checkNotNull();
        return NativeObject.wrapPointer(_getTriangleIndices(address));
    }
    private static native long _getTriangleIndices(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTriangleIndicesCount() {
        checkNotNull();
        return _getTriangleIndicesCount(address);
    }
    private static native int _getTriangleIndicesCount(long address);

    /**
     * @return WebIDL type: {@link PxParticleClothConstraint}
     */
    public PxParticleClothConstraint getConstraints() {
        checkNotNull();
        return PxParticleClothConstraint.wrapPointer(_getConstraints(address));
    }
    private static native long _getConstraints(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getConstraintCount() {
        checkNotNull();
        return _getConstraintCount(address);
    }
    private static native int _getConstraintCount(long address);

    public void calculateMeshVolume() {
        checkNotNull();
        _calculateMeshVolume(address);
    }
    private static native void _calculateMeshVolume(long address);

    /**
     * @return WebIDL type: float
     */
    public float getMeshVolume() {
        checkNotNull();
        return _getMeshVolume(address);
    }
    private static native float _getMeshVolume(long address);

}
