package physx.physics;

/**
 * Flag that configures articulation-state updates by PxArticulationReducedCoordinate::updateKinematic.
 */
public enum PxArticulationKinematicFlagEnum {

    /**
     * Raise after any changes to the articulation root or joint positions using non-cache API calls. Updates links' positions and velocities.
     */
    ePOSITION(getePOSITION()),
    eVELOCITY(geteVELOCITY());
    public final int value;
    
    PxArticulationKinematicFlagEnum(int value) {
        this.value = value;
    }

    private static native int _getePOSITION();
    private static int getePOSITION() {
        de.fabmax.physxjni.Loader.load();
        return _getePOSITION();
    }

    private static native int _geteVELOCITY();
    private static int geteVELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteVELOCITY();
    }

    public static PxArticulationKinematicFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationKinematicFlagEnum: " + value);
    }

}
