package physx.support;

import physx.NativeObject;

/**
 * PxPvd is the top-level class for the PVD framework, and the main customer interface for PVD
 * configuration.It is a singleton class, instantiated and owned by the application.
 */
public class PxPvd extends NativeObject {

    protected PxPvd() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPvd wrapPointer(long address) {
        return address != 0L ? new PxPvd(address) : null;
    }
    
    public static PxPvd arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPvd(long address) {
        super(address);
    }

    // Functions

    /**
     * Connects the SDK to the PhysX Visual Debugger application.
     * \param transport transport for pvd captured data.
     * \param flags Flags to set.
     * return True if success
     */
    public boolean connect(PxPvdTransport transport, PxPvdInstrumentationFlags flags) {
        checkNotNull();
        return _connect(address, transport.getAddress(), flags.getAddress());
    }
    private static native boolean _connect(long address, long transport, long flags);

    /**
     * Releases the pvd instance.
     */
    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
