package physx.support;

import physx.NativeObject;

public class PxPvdInstrumentationFlags extends NativeObject {

    protected PxPvdInstrumentationFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPvdInstrumentationFlags wrapPointer(long address) {
        return address != 0L ? new PxPvdInstrumentationFlags(address) : null;
    }
    
    public static PxPvdInstrumentationFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPvdInstrumentationFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxPvdInstrumentationFlags(byte flags) {
        address = _PxPvdInstrumentationFlags(flags);
    }
    private static native long _PxPvdInstrumentationFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxPvdInstrumentationFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     */
    public void raise(PxPvdInstrumentationFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxPvdInstrumentationFlagEnum} [enum]
     */
    public void clear(PxPvdInstrumentationFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
