package physx.vehicle2;

import physx.NativeObject;

public class EngineDrivetrainParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static EngineDrivetrainParams wrapPointer(long address) {
        return address != 0L ? new EngineDrivetrainParams(address) : null;
    }
    
    public static EngineDrivetrainParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected EngineDrivetrainParams(long address) {
        super(address);
    }

    // Constructors

    public EngineDrivetrainParams() {
        address = _EngineDrivetrainParams();
    }
    private static native long _EngineDrivetrainParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleAutoboxParams} [Value]
     */
    public PxVehicleAutoboxParams getAutoboxParams() {
        checkNotNull();
        return PxVehicleAutoboxParams.wrapPointer(_getAutoboxParams(address));
    }
    private static native long _getAutoboxParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleAutoboxParams} [Value]
     */
    public void setAutoboxParams(PxVehicleAutoboxParams value) {
        checkNotNull();
        _setAutoboxParams(address, value.getAddress());
    }
    private static native void _setAutoboxParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleClutchCommandResponseParams} [Value]
     */
    public PxVehicleClutchCommandResponseParams getClutchCommandResponseParams() {
        checkNotNull();
        return PxVehicleClutchCommandResponseParams.wrapPointer(_getClutchCommandResponseParams(address));
    }
    private static native long _getClutchCommandResponseParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchCommandResponseParams} [Value]
     */
    public void setClutchCommandResponseParams(PxVehicleClutchCommandResponseParams value) {
        checkNotNull();
        _setClutchCommandResponseParams(address, value.getAddress());
    }
    private static native void _setClutchCommandResponseParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleEngineParams} [Value]
     */
    public PxVehicleEngineParams getEngineParams() {
        checkNotNull();
        return PxVehicleEngineParams.wrapPointer(_getEngineParams(address));
    }
    private static native long _getEngineParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleEngineParams} [Value]
     */
    public void setEngineParams(PxVehicleEngineParams value) {
        checkNotNull();
        _setEngineParams(address, value.getAddress());
    }
    private static native void _setEngineParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleGearboxParams} [Value]
     */
    public PxVehicleGearboxParams getGearBoxParams() {
        checkNotNull();
        return PxVehicleGearboxParams.wrapPointer(_getGearBoxParams(address));
    }
    private static native long _getGearBoxParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleGearboxParams} [Value]
     */
    public void setGearBoxParams(PxVehicleGearboxParams value) {
        checkNotNull();
        _setGearBoxParams(address, value.getAddress());
    }
    private static native void _setGearBoxParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleMultiWheelDriveDifferentialParams} [Value]
     */
    public PxVehicleMultiWheelDriveDifferentialParams getMultiWheelDifferentialParams() {
        checkNotNull();
        return PxVehicleMultiWheelDriveDifferentialParams.wrapPointer(_getMultiWheelDifferentialParams(address));
    }
    private static native long _getMultiWheelDifferentialParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleMultiWheelDriveDifferentialParams} [Value]
     */
    public void setMultiWheelDifferentialParams(PxVehicleMultiWheelDriveDifferentialParams value) {
        checkNotNull();
        _setMultiWheelDifferentialParams(address, value.getAddress());
    }
    private static native void _setMultiWheelDifferentialParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleFourWheelDriveDifferentialParams} [Value]
     */
    public PxVehicleFourWheelDriveDifferentialParams getFourWheelDifferentialParams() {
        checkNotNull();
        return PxVehicleFourWheelDriveDifferentialParams.wrapPointer(_getFourWheelDifferentialParams(address));
    }
    private static native long _getFourWheelDifferentialParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleFourWheelDriveDifferentialParams} [Value]
     */
    public void setFourWheelDifferentialParams(PxVehicleFourWheelDriveDifferentialParams value) {
        checkNotNull();
        _setFourWheelDifferentialParams(address, value.getAddress());
    }
    private static native void _setFourWheelDifferentialParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleTankDriveDifferentialParams} [Value]
     */
    public PxVehicleTankDriveDifferentialParams getTankDifferentialParams() {
        checkNotNull();
        return PxVehicleTankDriveDifferentialParams.wrapPointer(_getTankDifferentialParams(address));
    }
    private static native long _getTankDifferentialParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleTankDriveDifferentialParams} [Value]
     */
    public void setTankDifferentialParams(PxVehicleTankDriveDifferentialParams value) {
        checkNotNull();
        _setTankDifferentialParams(address, value.getAddress());
    }
    private static native void _setTankDifferentialParams(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleClutchParams} [Value]
     */
    public PxVehicleClutchParams getClutchParams() {
        checkNotNull();
        return PxVehicleClutchParams.wrapPointer(_getClutchParams(address));
    }
    private static native long _getClutchParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchParams} [Value]
     */
    public void setClutchParams(PxVehicleClutchParams value) {
        checkNotNull();
        _setClutchParams(address, value.getAddress());
    }
    private static native void _setClutchParams(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link EngineDrivetrainParams} [Value]
     */
    public EngineDrivetrainParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return EngineDrivetrainParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

}
